#|____________________________________________________________________
 |
 |  messages4.lsp 
 |  this file has code that implements the documentation print function,
 |  fwy biography, about-vista and seeing-data functions
 |  Copyright (c) 2001 by Forrest W. Young
 |  All rights reserved 
 |____________________________________________________________________
 |#

#|____________________________________________________________________
 |
 |  PRINT DOCO
 |____________________________________________________________________
 |#

(setf *print-help-mode* nil)
(defun print-help-topics ()
  (setf *print-help-mode* t)
  (set-working-directory *default-path*)
  (when *help-window* (send *help-window* :close))
  (setf *one-liner* (one-liner "Generate Help Topics" :time nil))
   (let* ((chap-file "chapters.txt")
         (actions-list nil)
         (topic-list (append (select (welcome-topic-list) '(1 0)) 
                             (select (topic-list) '(2 4 3 5 6 7 8 9 10 11))
                             (menu-item-topic-list)))
         (parts-list (list "PART I:   WELCOME" "PART II:  GETTING STARTED" 
                           "PART III: UNDERSTANDING DATA" "PART IV:  ENHANCING VISTA" 
                           "APPENDIX:   VISTA'S MENUS"))
         (part-names-list (list "WELCOME" "GETTING STARTED" 
                           "UNDERSTANDING DATA" "ENHANCING VISTA" 
                           "APPENDIX: VISTA'S MENUS"))
         (roman (list "I" "II " "III" "IV" "A"))
         (k -1)
         (subtopics-list )
         (infile-list nil)
         (title-list))
    (setf *doco-path* (strcat *default-path* "help\\help\\"))
    (setf actions-list (append (select (welcome-actions-list) '(1 0))
                               (select (actions-list) '(2 4 3 5 6 7 8 9 10 11))
                               (menu-item-action-list)))
    (setf subtopics-list (append (select (welcome-subtopics-list) '(1 0))
                                 (select (subtopics-list) '(2 4 3 5 6 7 8 9 10 11))
                                 (menu-item-subtopic-list)))
    (with-open-file
      (chap-stream chap-file :direction :output)
      (dolist (i (iseq (length actions-list)))
             (setf ii (1+ i))
             (case ii
               (1  (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (3  (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (8  (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (12 (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (13 (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k))))
              (if (< k 4)
                  (format chap-stream "~%          Topic ~2,d  ~a~%" 
                          ii (string-capitalize (select topic-list i)))
                  (format chap-stream "~%         ~a~%" 
                          (string-capitalize (select topic-list i))))
              (dotimes (j (length (select actions-list i)))
                       (setf jj (1+ j))
                       (unless (or (and (= ii 1) (= jj 4))
                                   (and (= ii 3) (> jj 2)))
                               (if (< k 4)
                                   (format chap-stream "                   ~2,d.~d    ~A~%" 
                                           ii jj
                                           (string-capitalize 
                                            (select (select subtopics-list i) j)))
                                   (format chap-stream "         ~d    ~a~%"
                                           jj
                                           (string-capitalize 
                                            (select (select subtopics-list i) j))))
                               (send *one-liner* :title 
                                     (format nil "~d.~d - ~A" 
                                             ii jj
                                             (string-capitalize 
                                              (select (select subtopics-list i) j))))
                               (setf title 
                                     (format nil "~a - ~a - ~a (~a.~d.~d)"
                                             (select part-names-list k)
                                             (select topic-list i)
                                             (select (select subtopics-list i) j)
                                             (select roman k) ii jj))
                               (setf title-list (append title-list (list title)))
                               (setf new-help-file (format nil "~ahelp~s-~s.txt"
                                                           *doco-path* ii jj))
                               (eval (select (select actions-list i) j))
                               (send *help-window* :write-text-to-file
                                    (send *help-window* :strings) new-help-file t)
                               (setf infile-list (append infile-list (list new-help-file)))
                               ))))

     (send *one-liner* :title   "Generating Help Document")
     (print-documentation infile-list title-list)
     (send *one-liner* :title   "Displaying Help Document")
     (set-working-directory *default-path*)
     (system "allhelp.bat")
     (initial-help-window :show nil)
     (send *one-liner* :remove)
     ))



(defun print-documentation (infile-list title-list)
  (set-working-directory *default-path*)
  (let* ((text-line)(text-list)
         (chapfile "chapters.txt")
         (outfile "AllHelp.doc"))
    (setf infile-list (append (list (strcat *default-path* "chapters.txt")) infile-list))
    (setf title-list  (combine (format nil "ViSta's Help Files Organized by Topic")
                               title-list))
    (with-open-file (outstream outfile :direction :output)
                    (mapcar #'(lambda (infile title)
                                (with-open-file (instream infile :direction :input)
                                                (loop
                                                 (setf text-line 
                                                       (read-line instream nil nil))
                                                 (unless text-line (return))
                                                 (setf text-list 
                                                       (append text-list 
                                                               (list (list text-line)))))
                                                (paragraph-text-list-to-text-stream
                                                 text-list title outstream)
                                                (setf text-list nil)
                                                ))
                            infile-list title-list)
                     )
    ))

(defun print-file ()
  (set-working-directory *default-path*)
  (let* ((outfile "doco.txt")
         (infile-list (list (open-file-dialog)))
         (title-list infile-list))
    (with-open-file (outstream outfile :direction :output)
                    (print-documentation infile-list title-list outstream))
    (system (strcat "notepad.exe /p doco.txt"))))
   

 (defun print-file (&optional file)
   (unless file (setf file (read-file-dialog)))
   (when file
         (system (strcat "notepad.exe /p " file))))
     


             
(defun print-all-reports ()
  (set-working-directory  *default-path*)
  (setcm *current-model*)
  (let* ((text-list) (text-line)
         (outfile-name "ViSta Report")
         (anal-w) (intr-w) (modl-w) (stat-w))

    (setf stat-w  (summarize-data :data t :about t 
                                  :correlations t :covariances t :frequencies t))
    (send stat-w :location 3000 3000)
    (send stat-w :write-text-to-file (send *display-window* :strings) "stat-rpt.txt")
    (let* ((hwloc (when *help-window* (send *help-window* :location))))
      (when *help-window* :send *help-window* :location 3000 3000)
      (about-the-analysis)
      (when (not hwloc) (send *help-window* :location 3000 3000))
      (setf anal-w *help-window*)
      (send anal-w :location 3000 3000)
      (send anal-w :write-text-to-file 
            (send *help-window* :strings) "anal-rpt.txt")
      (setf *help-window* nil))
    (report-model)
    (send *display-window* :location 3000 3000)
    (setf modl-w *display-window*)
    (send modl-w :write-text-to-file 
          (send modl-w :strings) "modl-rpt.txt")
    (when (send interpret-model-menu-item :enabled) 
          (setf intr-w (interpret-model))
          (send *display-window* :location 3000 3000)
          (send intr-w :write-text-to-file (send intr-w :strings) "intr-rpt.txt"))
    
    
    
    (setf infile-list (list "stat-rpt.txt" "anal-rpt.txt" "modl-rpt.txt"))
    (setf title-list (list "" "A N A L Y S I S" "R E S U L T S"))
    (when (send interpret-model-menu-item :enabled)
          (send intr-w :write-text-to-file (send stat-w :strings) "intr-rpt.txt")
          (setf infile-list (combine infile-list "intr-rpt.txt"))
          (setf title-list (combine title-list "I N T E R P R E T A T I O N"))
          )
    (setf all-results-file-name 
          (strcat "ANALYSIS OF " (SEND (SEND SELF :DATA-OBJECT) :PROPER-NAME) ".txt"))
    (with-open-file (outstream all-results-file-name :direction :output)
                    (mapcar #'(lambda (infile title)
                                (with-open-file (instream infile :direction :input)
                                                (loop
                                                 (setf text-line 
                                                       (read-line instream nil nil))
                                                 (unless text-line (return))
                                                 (setf text-list 
                                                       (append text-list 
                                                           (list (list text-line)))))
                                                (paragraph-text-list-to-text-stream
                                                 text-list title outstream)
                                                (setf text-list nil)
                                                ))
                            infile-list title-list))
    (system (strcat "notepad.exe /p " all-results-file-name ))
    ))


(defun merge-text-files (infile-list title-list outfile)
  (let* ((text-line)(text-list))
    (with-open-file (outstream outfile :direction :output)
                    (mapcar #'(lambda (infile title)
                                (with-open-file (instream infile :direction :input)
                                                (loop
                                                 (setf text-line 
                                                       (read-line instream nil nil))
                                                 (unless text-line (return))
                                                 (setf text-list 
                                                       (append text-list 
                                                               (list (list text-line)))))
                                                (paragraph-text-list-to-text-stream
                                                 text-list title outstream)
                                                (setf text-list nil)
                                                ))
                            infile-list title-list)
                     )
    ))


(defun text-lol-to-paragraphs (text-lol)
  (Let* (;(text-lol (select (get-text-messages 16) (iseq 2 15)))
         (text-list)
         (instring) (outstring))
    (dotimes (i (length text-lol))
             (setf text-list (select text-lol i))
             (setf text-list (select text-list (iseq 2 (1- (length text-list)))))
             (mapcar #'(lambda (instring)
                         (setf outstring (strcat outstring instring))
                         )
                     text-list)
             (format t "~%~a~%" outstring)
             (setf outstring nil))
    outstring))

(defun paragraph-text-list-to-text-stream (intext intitle outstream )
  (let ((num-strings (length intext))
        (oldbreak *breakenable*))
    (setq *breakenable* nil)
    (unwind-protect 
     (format outstream "~%~%~a~%" intitle)
             (string-upcase intitle))
     (dotimes (i num-strings)
              (format outstream "~a~%"  (first (select intext i))))
     (format outstream "~%~%~%~%~%")
    (setq *breakenable* oldbreak)))


(defun paragraph-text-list-to-html-stream (intext intitle outstream)
  (let ((num-strings (length intext))
        (oldbreak *breakenable*))
    (setq *breakenable* nil)
    (unwind-protect 
     (format outstream "______________________________~% |~% |~a~% |______________________________~%~%" intitle)
             (string-upcase intitle))
     (dotimes (i num-strings)
              (format outstream "~a~%"  (first (select intext i))))
     (format outstream "~%~%~%~%~%")
    (setq *breakenable* oldbreak)))




#|____________________________________________________________________
 |
 |  SEEING DATA
 |____________________________________________________________________
 |#

(setf *seeing-data-panel* nil)

(defun seeing-data-topic-list (&optional (*full* *full-help-panel* ))
  (remove 'nil (list 
                "WELCOME TO VISTA"
                "  Getting Help"
                "  What's New?"
                "  About ViSta"
                
                "GETTING HELP"
                "  Help Resources"
                
                "GETTING STARTED"
                "  Using The DeskTop" 
                "  Using The Menus" 
                "  The Options Menu"
                "  The Data Menu"
                
                "MANAGING YOUR DATA"
                "  Entering Data" 
                "  Data from Excel"
                "  Managing Data"
                "  Reporting Data"
                
                "EXPLORING YOUR DATA"
                "  Seeing Your Data"
                "  Graphing Data" 
                "  Visualizing Data"
                "  Examples: Exploring Data"

                "INSIGHT FROM DATA MODELS"
                "  Transforming Your Data"
                "  Analyzing Your Data"
                "  Exploring Your Model"
                
                "EXPLORING YOUR INSIGHT"
                "  Seeing Your Model"
                "  Graphing Your Model"
                "  Visualizing Your Model"
                "  Interpreting Your Model"
                "  Examples: Data Insight"

                "ENHANCING YOUR INSIGHT"           
                "  Advanced Topics"



                "Close/Remove")))


(defun seeing-data-subtopics-list (&optional (*full* *full-help-panel* ))
  (setf *full* t)
  (remove 'nil
           (list
            (list "WELCOME!")
            (list "Getting Help" "Learning More" 
                  "Register with Us" "Join the News Group")
            (list "About ViSta 6" "New Features" )
            (list "Summary" "Contacting Us" "Copyrights" 
                  "Seeing and Insight" "Acknowledgments" 
                  "About The Author") 

            (list "HELP!")
            (list "Help Topics" "ViSta OnLine" "Help OnLine" 
                  "Register With Us" "Join the NewsGroup")

            (list "GETTING STARTED")
            (list "Summary" "DeskTop Options" "WorkMap Help" 
                  "ToolBar Help" 
                  "DataSheet Help" "Selector Help" "Listener Help")
            (list "Summary" "The Options Menu" "The Window Menu" 
                  "Menu Item Help" )
            (get-menu-item-titles *command-menu*) 
            (get-menu-item-titles *data-menu*)

            (LIST "MANAGING YOUR DATA")
            (list "ViSta's DataSheet" "Excel SpreadSheets" "SAS Datasets"
                  "Importing Data" "Simulating Data" "Writing DataCode")
            (list "Summary" "From Excel to ViSta" 
                  "From ViSta to Excel" 
                  "Notes about Using Excel" "Changing Excel's ViSta Menu")
            (list "Summary" "Variable and Data Types" 
                  "Manipulating Variables" "Using ViVa" 
                  "Making Variables" "Making Data")
            (list "Summary" "Summarizing Data" "Reporting Models")
            
            (LIST "EXPLORING YOUR DATA" "Seeing Your Data" "Exploring Your Insights")
            (list "Seeing Your Data" "Graphing Data" "Visualizing Data")
            (list "About The Graphs" "Dot Plot" "Box Plot" "Diamond Plot" 
                  "Frequency Distribution" "Histogram" 
                  "Quantile Plot" "Quantile-Quantile Plot" 
                  "Normal Probability Plot" "Bar Chart" "Mosaic Plot" 
                  "Scatterplot" "Spin Plot" 
                  "Scatterplot Matrix" "Tour Plot")
            (list "About The  SpreadPlots"
                  "Univariate SpreadPlot" "Bivariate SpreadPlot" 
                  "Multivariate SpreadPlot" 
                  "Categorical SpreadPlot" "CrossTabs  SpreadPlot" 
                  "Classification  SpreadPlot"
                  "Guided Tour SpreadPlot" "Freuency Data SpreadPlot")
            
            (LIST "EXPLORING YOUR INSIGHTS" 
                  "Transforming Data" "Analyzing Data" "Modeling Data")
            (combine "Transforming Data" (get-menu-item-titles *trans-menu*))
            (combine "Analyzing Data" (get-menu-item-titles *analyze-menu*))
            (combine "Modeling Data" (get-menu-item-titles *model-menu*))
            (list "Interpreting Models" "Analysis of Variance" 
                  "Univariate Analysis")
           

            (LIST "ENHANCING YOUR INSIGHTS")
            (list "Summary" "Central Limit Theorem"
                  "Univariate Analysis" "Analysis of Variance"
                  "Influential Points" "Restricted Range"
                  "Missing Data Imputation" "Box-Cox Visualization")
            (list "Writing SpreadPlots" "Writing Plugins" "DataTypes")
            (list "Close or Remove Panel"))))

(defun seeing-data-actions-list (&optional (*full* *full-help-panel* ))
  (setf *full* t)
  (remove 'nil
          (list
            (list '(welcome-message))
            (list  '(help!) '(welcome5-message) '(online-register) '(online-newsgroup))
           (list '(about-version-6 ) '(new-features)) 
           

           (list '(about-summary)  '(title-cinerama)
                 '(copyright-cinerama) '(poem-cinerama) '(acknowledgements-cinerama)
                 '(fwy-cinerama) )

           (list '(HELP!) )
           (list '(topics) '(vista-online) '(online-help) 
                 '(online-register) '(online-newsgroup) )
         

           (LIST '(GETTING-STARTED))
           (list '(desktop-help) '(desktop-options-help) '(workmap-help)  
                 '(toolbar-help) '(datasheet-help)
                 '(selector-help) '(listener-help))
           (list '(menu-help-without-item-help ) '(options-menu) '(window-menu) 
                 '(menu-item-on-off-help))
           (make-menu-item-help-function-list *command-menu*)
           (make-menu-item-help-function-list *data-menu*)
           

           (LIST '(MANAGING-YOUR-DATA))
           (list '(using-the-datasheet) '(from-excel-to-vista) '(SAS2ViSta)
                 '(importing-data) '(simulating-data) '(the-datacode-editor))
           (list '(using-excel-and-vista) '(from-excel-to-vista)
                 '(from-vista-to-excel)
                 '(notes-about-using-excel) '(changing-excels-vista-menu))
           (list '(about-the-data-system) '(vartypes-datatypes) '(manipulating-variables)
                 '(the-variable-language) '(the-variable-maker) '(the-data-maker))
           (when *full*  (list '(report-summary) '(summarizing-data) '(reporting-models)))
        
           (LIST '(UNDERSTANDING YOUR DATA) '(seeing-your-data) '(testing-your-insights))
           (LIST '(SEEING-YOUR-DATA) '(about-the-graphs) '(about-the-spreadplots))
           (list '(about-the-graphs) '(dot-plot-help) 
                 '(box-plot-help) '(diamond-plot-help)
                 '(frequency-distribution-help) '(histogram-help)
                 '(quantile-plot-help) '(quantile-quantile-plot-help ) 
                 '(normal-probability-plot-help) '(bar-graph-help) '(mosaic-plot-help)
                 '(scatterplot-help)'(spinplot-help)
                 '(scatmat-help)'(tourplot-help))
           (when *full*  (list '(about-the-spreadplots) '(Categorical-SpreadPlot) 
                               '(spreadplot-summary) '(Univariate-SpreadPlot) 
                               '(bivariate-SpreadPlot)'(multivariate-spreadPlot) 
                               '(categorical-spreadplot) '(CrossTabs-SpreadPlot)
                               '(Classification-SpreadPlot)
                               '(guided-tour-spreadplot) '(frequency-spreadplot)))

           (LIST '(TESTING-YOUR-INSIGHTS) '(transforming-data) '(analyzing-data) '(modeling-data))
           (make-menu-item-help-function-list *trans-menu*)
           (make-menu-item-help-function-list *analyze-menu*)
           (make-menu-item-help-function-list *model-menu*)
           (when *full* (list '(not-yet-written)))
        ;  (when *full* (list '(not-yet-written) '(not-yet-written) '(not-yet-written)))

                 (LIST '(ENHANCING VISTA))
           (list '(demos-data-message) '(do-uni) '(do-bi) '(do-class)
                 '(do-multi) '(do-tour) '(do-freq) '(do-cat) '(do-crstab))
           (when *full* (list '(demos-message) '(demo-simulate)
                              '(demo-univar) '(demo-anova)
                              '(demo-reg-influence) '(demo-reg-range)
                              '(demo-missing) '(demo-boxcox)))
           (list '(writing-spreadplots) '(writing-plugins) '(data-type-help))
           
           (list '(close-remove))
           )))

;;;(listeners)

#|__ help-panel ___________________________|#
  (defun seeing-data (&optional (initial-topic nil) (initial-subtopic nil) 
                                     (show t))
"Args - &optional (initial-topic nil) (initial-subtopic nil) (show-message nil)
Present help panel with topic INITIAL-TOPIC and subtopic INITIAL-SUBTOPIC selected and their action has occured. If INITIAL-TOPIC is nil, no topic or subtopic is selected. If INITIAL-TOPIC  and INITIAL-SUBTOPIC are both a non-negative integer in the appropriate range, then the specified INITIAL-TOPIC and INITIAL-SUBTOPIC is intially selected. The initial subtopic is shown unless show is nil."
  (if *seeing-data-panel* 
      (send *seeing-data-panel* 
         :show-window initial-topic initial-subtopic
         :do-action show)
      (make-seeing-data-panel initial-topic initial-subtopic show))
    )

(defun make-seeing-data-panel (initial-topic initial-subtopic show)
   (let* ((datademo (not (not (load (strcat *demos-path* "datademo.lsp") 
                                    :if-does-not-exist nil))))
          (analdemo t)
          (multidemo (not (not (load (strcat *demos-path* "mvardemo.lsp")
                                     :if-does-not-exist nil))))
          (topics (seeing-data-topic-list t))
          (subtopics (seeing-data-subtopics-list t))
          (actions (seeing-data-actions-list t))
          (dialog
           (double-list-dialog topics subtopics actions
                               :initial (list initial-topic initial-subtopic)
                               :max-list-length-shown 50 
                               :first t
                               :title "Seeing Data"
                               :location (effective-screen-size)
                               :close nil))
          )
     
     (setf *seeing-data-panel* dialog)
     (apply #'send dialog :location 
            (- (effective-screen-size) (send dialog :size) (list 4 4)))

     (defmeth dialog :close () 
       (setf *seeing-data-panel* nil)
       ;(send self :showing nil)
        (call-next-method))
     (send dialog :show-window initial-topic initial-subtopic 
           :do-action show)

     dialog))
   
